using System;
using CoreLib.Commands;
using CoreLib.Commands.Communication;
using JetBrains.Annotations;
using PugMod;
using Unity.Entities;
using Unity.NetCode;
using UnityEngine;

namespace CrowdControl.CommandHandlers
{
    [UsedImplicitly]
    public class SpawnCommandHandler : IServerCommandHandler//, IClientCommandHandler
    {
        public string GetDescription() => "Spawns an object at specified coordinates.";

        private static string[] TRIGGER_NAMES = { "cc_spawn" };
        public string[] GetTriggerNames() => TRIGGER_NAMES;
        
        public CommandOutput Execute(string[] parameters)
        {
            Debug.Log($"Received command cc_spawn {string.Join(" ", parameters)}");

            if (!API.Server.World.IsServer())
                return new("Not a server world, skipping.", CommandStatus.Warning);
            
            if (parameters.Length < 4)
                return new("Not enough parameters. Usage: cc_spawn <objectID> <x> <y> <z>", CommandStatus.Error);

            if (!Enum.TryParse(parameters[0], true, out ObjectID obj))
            {
                if (!int.TryParse(parameters[0], out int objInt))
                    return new($"Invalid object ID: {parameters[0]}", CommandStatus.Error);
                obj = (ObjectID)objInt;
            }

            if ((!float.TryParse(parameters[1], out var x)) ||
                (!float.TryParse(parameters[2], out var y)) ||
                (!float.TryParse(parameters[3], out var z)))
                return new("Invalid coordinates. Please provide valid numbers for x, y, and z.", CommandStatus.Error);

            API.Server.InstantiateObject((int)obj, 0, new(x, y, z));

            return new($"{obj:G} spawned at ({x}, {y}, {z}).", CommandStatus.Info);
        }

        public CommandOutput Execute(string[] parameters, Entity sender) => Execute(parameters);
    }
}